/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.leospa.main;

import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.concurrent.ExecutionException;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.SwingWorker;
import javax.swing.text.Document;

import com.leospa.bean.Command_0;
import com.leospa.bean.Command_1;
import com.leospa.properties.ColorPropertiesFile;
import com.leospa.properties.ConfigPropertiesFile;
import com.leospa.properties.ContentPropertiesFile;
import com.leospae.handler.Command_0_handler;
import com.leospae.handler.Command_1_handler;

/**
 *
 * @author vaibhav.bhardwaz
 */
public class LoadingMainScreen{

	int count = 0; 
	Hashtable command_0_res;
	MainScreen mainScreen;
	javax.swing.GroupLayout layout;

	public LoadingMainScreen(MainScreen mainScreen, javax.swing.GroupLayout layout) {
		this.layout = layout;
		this.mainScreen = mainScreen;

		initComponents();
		startWork();

	}
	
	public void startWork(){
		SwingWorker<Hashtable, Void> worker = new SwingWorker<Hashtable, Void>() {
		     @Override
		     public Hashtable doInBackground() {
					Hashtable command0_has = new Command_0_handler().getCommand0(mainScreen,layout);
					if(command0_has != null && command0_has.size() >0){
						Util.getUtilInstance().setCommand_0_hash(command0_has);
						}
					return command0_has;
		     }
		     @Override
		     public void done() {
		       try {
		    	   command_0_res = get();
		    	   if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.out.println("Returned Command 0: "+command_0_res.toString());}
		    	   if (command_0_res != null && command_0_res.size() >0) {
		    		   jPanel1.setVisible(false);
		   				OptionScreen optionScreen = new OptionScreen(mainScreen,layout);
		   				optionScreen.setLayout();
						
					} else {
						jPanel1.setVisible(false);
						ServicePersonalScreen servicePersonalScreen = new ServicePersonalScreen(mainScreen,layout);
						servicePersonalScreen.setLayout();
					}
		       } catch (InterruptedException ex) {
		         ex.printStackTrace();
		       } catch (ExecutionException ex) {
		         ex.printStackTrace();
		       }
		     }
		   };

		   // Call the SwingWorker from within the Swing thread
		   worker.execute();
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated Code">
	private void initComponents() {

		jPanel1 = new javax.swing.JPanel();
		jPanel2 = new javax.swing.JPanel();
		jLabel1 = new javax.swing.JLabel();
		jButton1 = new javax.swing.JButton();
		jLabel2 = new javax.swing.JLabel();


		jPanel1.setMaximumSize(new java.awt.Dimension(800, 1280));
		jPanel1.setMinimumSize(new java.awt.Dimension(800, 1280));
		jPanel1.setOpaque(false);
		jPanel1.setPreferredSize(new java.awt.Dimension(800, 1280));
		Color color = Color.decode(ColorPropertiesFile.Popup_BG_Color);
		jPanel2.setBackground(color);
		jPanel2.setPreferredSize(new java.awt.Dimension(786, 768));

		jLabel1.setFont(new java.awt.Font("SansSerif", 1, 45)); // NOI18N
		color = Color.decode(ColorPropertiesFile.Popup_Text_Color);
		jLabel1.setForeground(color);
		jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		jLabel1.setText(ContentPropertiesFile.Laoding);

		 try {
				URL imgURL = new File( "./images/3.png" ).toURI().toURL();
				jButton1.setIcon(new javax.swing.ImageIcon(imgURL)); // NOI18N
			} catch (MalformedURLException e) {
				// TODO Auto-generated catch block
				if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
			}
		jButton1.setOpaque(false);
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton1ActionPerformed(evt);
			}
		});

		 try {
				URL imgURL = new File( "./images/refresh.gif" ).toURI().toURL();
				jLabel2.setIcon(new javax.swing.ImageIcon(imgURL)); // NOI18N
			} catch (MalformedURLException e) {
				// TODO Auto-generated catch block
				if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
			}
		 
		 javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
	        jPanel2.setLayout(jPanel2Layout);
	        jPanel2Layout.setHorizontalGroup(
	            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
	            .addGroup(jPanel2Layout.createSequentialGroup()
	                .addContainerGap()
	                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
	                    .addGroup(jPanel2Layout.createSequentialGroup()
	                        .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 766, Short.MAX_VALUE)
	                        .addContainerGap())
	                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
	                        .addGap(0, 0, Short.MAX_VALUE)
	                        .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE))))
	            .addGroup(jPanel2Layout.createSequentialGroup()
	                .addGap(154, 154, 154)
	                .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 453, javax.swing.GroupLayout.PREFERRED_SIZE)
	                .addGap(0, 0, Short.MAX_VALUE))
	        );
	        jPanel2Layout.setVerticalGroup(
	            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
	            .addGroup(jPanel2Layout.createSequentialGroup()
	                .addGap(212, 212, 212)
	                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE)
	                .addGap(42, 42, 42)
	                .addComponent(jLabel2)
	                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 100, Short.MAX_VALUE)
	                .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE))
	        );
//=======================

		javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
		jPanel1.setLayout(jPanel1Layout);
		jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0)
						.addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE,
								javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
						.addContainerGap(150, Short.MAX_VALUE)));
		jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup()
						.addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE,
								javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
						.addGap(0, 880, Short.MAX_VALUE)));

	
	}// </editor-fold>
	
	
	public void setLayout(){
		layout = new javax.swing.GroupLayout(mainScreen.getContentPane());
		mainScreen.getContentPane().setLayout(layout);
		layout.setHorizontalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
				javax.swing.GroupLayout.Alignment.TRAILING,
				layout.createSequentialGroup().addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
						.addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE,
								javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
						.addContainerGap()));
		layout.setVerticalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(layout.createSequentialGroup().addGap(8, 8, 8)
						.addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE,
								javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
						.addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)));

		mainScreen.pack();
	}

	private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {
		jPanel1.setVisible(false);
		/*ServicePersonalScreen servicePersonalScreen = new ServicePersonalScreen(mainScreen,layout);
		servicePersonalScreen.setLayout();*/
		LeoSpaMainFrame mainFrame=new LeoSpaMainFrame(mainScreen, layout);
		mainFrame.setLayout();
		
		MainScreen leoSpaMainFrame = new MainScreen();
	    leoSpaMainFrame.setVisible(true);
	    mainScreen.dispose();
	}

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		/* Set the Nimbus look and feel */
		// <editor-fold defaultstate="collapsed" desc=" Look and feel setting
		// code (optional) ">
		/*
		 * If Nimbus (introduced in Java SE 6) is not available, stay with the
		 * default look and feel. For details see
		 * http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.
		 * html
		 */
		try {
			for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
				if ("Nimbus".equals(info.getName())) {
					javax.swing.UIManager.setLookAndFeel(info.getClassName());
					break;
				}
			}
		} catch (ClassNotFoundException ex) {
			java.util.logging.Logger.getLogger(LoadingMainScreen.class.getName()).log(java.util.logging.Level.SEVERE, null,
					ex);
		} catch (InstantiationException ex) {
			java.util.logging.Logger.getLogger(LoadingMainScreen.class.getName()).log(java.util.logging.Level.SEVERE, null,
					ex);
		} catch (IllegalAccessException ex) {
			java.util.logging.Logger.getLogger(LoadingMainScreen.class.getName()).log(java.util.logging.Level.SEVERE, null,
					ex);
		} catch (javax.swing.UnsupportedLookAndFeelException ex) {
			java.util.logging.Logger.getLogger(LoadingMainScreen.class.getName()).log(java.util.logging.Level.SEVERE, null,
					ex);
		}
		// </editor-fold>
//		new LoadingScreen().setVisible(true);
		/* Create and display the form */
//		java.awt.EventQueue.invokeLater(new Runnable() {
//			public void run() {
//				
//			}
//		});
	}

	// Variables declaration - do not modify
	private javax.swing.JButton jButton1;
	private javax.swing.JLabel jLabel1;
	private javax.swing.JLabel jLabel2;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JPanel jPanel2;
	// End of variables declaration
}
